#include <stdio.h>
#include <mpi.h>
#include <malloc.h>

#define COUNT 3

int  main(int argc, char **argv )
{
	int i,myid, numprocs;
 	int *all,*ids;
  	MPI_Status status;
  	char name[MPI_MAX_PROCESSOR_NAME];
  	int len;

  	MPI_Init(&argc, &argv);
  	MPI_Comm_size(MPI_COMM_WORLD, &numprocs);
  	MPI_Comm_rank(MPI_COMM_WORLD, &myid); 
  	MPI_Get_processor_name(name, &len);

  	ids = (int *) malloc(numprocs * COUNT * sizeof(int));
  	all = (int *) malloc(numprocs * COUNT * sizeof(int));

  	for (i=0;i<numprocs*COUNT;i++) 
		ids[i] = myid;

  	MPI_Alltoall(ids,COUNT,MPI_INT,all,COUNT,MPI_INT,MPI_COMM_WORLD);

  	if ( myid == 0 )
  	{	
  		printf(" RANK %i on %s: The test succeeded", myid, name);

  		/*for (i=0;i<numprocs*COUNT;i++)
   			printf("%d",all[i]);
		*/
  		printf("\n");
		
  		fflush(stdout);
  	}

  	MPI_Finalize();
}
